/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.listeners;

import de.dustplanet.passwordprotect.PasswordProtect;
import de.dustplanet.passwordprotect.jail.JailHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING"})
public class PasswordProtectBlockListener
implements Listener {
    private final PasswordProtect plugin;
    private final JailHelper jailHelper;

    public PasswordProtectBlockListener(PasswordProtect instance, JailHelper jailHelper) {
        this.plugin = instance;
        this.jailHelper = jailHelper;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.getConfig().getBoolean("prevent.blockPlace", true)) {
            UUID playerUUID = event.getPlayer().getUniqueId();
            if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
                event.setBuild(false);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.plugin.getConfig().getBoolean("prevent.blockBreak", true)) {
            UUID playerUUID = event.getPlayer().getUniqueId();
            if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
                event.setCancelled(true);
            }
        }
    }
}

